function ButtonTrackingObj(exp, titleName, cm, frame){
   this.VarTrivBtnTracking = new Variable( 'VarTrivBtnTracking', null, 0, cm, frame, exp, titleName, true );
   this.title = null;
}

ButtonTrackingObj.codeToStateMap =
{
	'N' : 'normalState',
	'O' : 'overState',
	'D' : 'downState',
	'A' : 'disabledState',
	'V' : 'visitedState',
	'S' : 'selectedState'
};
ButtonTrackingObj.stateToCodeMap = {};
for (var key in ButtonTrackingObj.codeToStateMap)
	ButtonTrackingObj.stateToCodeMap[ButtonTrackingObj.codeToStateMap[key]] = key;

ButtonTrackingObj.prototype.InitPageTracking = function ( )
{
	var THIS = this;
	var pageTrackData = this.VarTrivBtnTracking.getValue();
	var bDoInit = true;
	try {
	    if (pageTrackData && pageTrackData.length > 0 && pageTrackData != '~~~null~~~')
	    {
	        var topLevelSplit = pageTrackData.split('#');
	        if (topLevelSplit && topLevelSplit.length > 1)
            {
		        var arrIds = topLevelSplit[0].split(',');
		        var arrStatus = topLevelSplit[1].split(',');
		        for( var i=0; i<arrIds.length; i++ )
		        {
			        var id = parseInt( '0x' + arrIds[i] );
			        var status = arrStatus[i];
			        var node = this.FindNode( this.title, id );
			        if( node )
						node.v = ButtonTrackingObj.codeToStateMap[status] || status;
		        }
    		}
        }
    } catch (e) { }
}

ButtonTrackingObj.prototype.FindNode = function( node, id )
{
	if( node.id == id )
		return node;
	
	var match = null;
	if( typeof( node.c ) != 'undefined' ){
		for( var i=0; i<node.c.length; i++ ){
			match = this.FindNode( node.c[i], id );
			if( match != null )
				break;
		}
	}
	
	return match;
}

ButtonTrackingObj.prototype.InternalGetRangeStatus = function( node )
{
	if( node == null )
		return -1;
		
	if( typeof(node.c) == 'undefined' )
	{
		return node.v;
	}
	else
	{
		return 'normalState';
	}
}


ButtonTrackingObj.prototype.GetRangeStatus = function( id, bInit )
{
	var status = -1;
	if ( bInit ) 
		this.InitPageTracking();
	
	status = this.InternalGetRangeStatus( this.FindNode( this.title, id ) );

	return status;
}


ButtonTrackingObj.prototype.InternalSetRangeStatus=function( node, status )
{
	if( node == null )
		return;
	node.v = status;
	if( status == 0 && typeof(node.c)!='undefined')
	{
		for( var i=0; i<node.c.length; i++ )
			this.InternalSetRangeStatus( node.c[i], status ); 
	}
}

ButtonTrackingObj.prototype.SetRangeStatus = function( id, status /*0 or 1 or 2*/)
{
	this.InternalSetRangeStatus( this.FindNode(this.title, id), status );
	
	this.SavePageTracking();
}

ButtonTrackingObj.prototype.IterateTree = function( func )
{
	var stack = [];
	stack.push( this.title );
	var i = 0;
	while( stack.length > 0 )
	{
		var node = stack.shift();
		
		if( typeof(node.c) != 'undefined' )
			stack = node.c.concat(stack);
			
		//do the thing
		func( node, i, stack );
		i++;
	}	
}

ButtonTrackingObj.prototype.SavePageTracking = function()
{
	var fnIsSaveState = window.ObjButton && ObjButton.isSaveState || function () { return false; };
	var hexString = '';
	var arrayIds = [];
	var arrayStatus= [];
	
	this.IterateTree(function(node, i, stack){
		if (fnIsSaveState(node.v))
		{
			arrayIds.push(node.id);
			arrayStatus.push(node.v);
		}
	});
	
	for( var i=0; i<arrayIds.length; i++ )
		hexString += (i > 0 ? ',' : '') + arrayIds[i].toString(16);

	hexString += (arrayIds.length > 0 ? '#' : '');
	
	for (var i = 0; i < arrayStatus.length; i++)
		hexString += (i > 0 ? ',' : '') + (ButtonTrackingObj.stateToCodeMap[arrayStatus[i]] || arrayStatus[i]);

	//LD-8267 - Added a condition to avoid tracking null/empty data unnecessarily
	if (hexString.length > 0 || (getDisplayWindow().storeSuspendData && getDisplayWindow().storeSuspendData.indexOf('VarTrivBtnTracking') >= 0) || !this.VarTrivBtnTracking.bSCORM)
		this.VarTrivBtnTracking.set(hexString);
}

var trivBtnTracking = new ButtonTrackingObj(365,'southlake_pcs_e_learning_module', 0, null);
trivBtnTracking.title={id:1,v:0,c:[{id:1762,v:'normalState'},{id:1758,v:'normalState'},{id:8022,v:'normalState'},{id:75389,v:'normalState'},{id:70198,v:'normalState'},{id:70348,v:'normalState'},{id:70393,v:'normalState'},{id:70335,v:'normalState'},{id:70416,v:'normalState'},{id:79155,v:'normalState'},{id:70429,v:'normalState'},{id:77552,v:'normalState'},{id:96709,v:'normalState'},{id:77682,v:'normalState'},{id:77597,v:'normalState'},{id:77587,v:'normalState'},{id:77612,v:'normalState'},{id:77620,v:'normalState'},{id:77629,v:'normalState'},{id:77637,v:'normalState'},{id:77645,v:'normalState'},{id:98864,v:'normalState'},{id:100041,v:'normalState'},{id:250002,v:'normalState'},{id:249989,v:'normalState'},{id:249976,v:'normalState'},{id:249963,v:'normalState'},{id:98535,v:'normalState'},{id:101307,v:'normalState'},{id:101322,v:'normalState'},{id:101336,v:'normalState'},{id:101349,v:'normalState'},{id:250899,v:'normalState'},{id:104571,v:'normalState'},{id:104859,v:'normalState'},{id:105251,v:'normalState'},{id:105807,v:'normalState'},{id:106084,v:'normalState'},{id:106655,v:'normalState'},{id:70644,v:'normalState'},{id:108455,v:'normalState'},{id:70881,v:'normalState'},{id:70902,v:'normalState'},{id:109617,v:'normalState'},{id:70971,v:'normalState'},{id:70954,v:'normalState'},{id:71000,v:'normalState'},{id:111299,v:'normalState'},{id:71029,v:'normalState'},{id:112127,v:'normalState'},{id:112629,v:'normalState'},{id:113017,v:'normalState'},{id:113849,v:'normalState'},{id:120482,v:'normalState'},{id:120255,v:'normalState'},{id:120060,v:'normalState'},{id:119142,v:'normalState'},{id:71154,v:'normalState'},{id:255245,v:'normalState'},{id:255986,v:'normalState'},{id:256144,v:'normalState'},{id:256368,v:'normalState'},{id:71350,v:'normalState'},{id:256989,v:'normalState'},{id:257290,v:'normalState'},{id:257843,v:'normalState'},{id:258128,v:'normalState'},{id:71557,v:'normalState'},{id:258923,v:'normalState'},{id:259423,v:'normalState'},{id:259878,v:'normalState'},{id:260606,v:'normalState'},{id:260995,v:'normalState'},{id:261034,v:'normalState'},{id:261340,v:'normalState'},{id:261716,v:'normalState'},{id:262277,v:'normalState'},{id:262674,v:'normalState'},{id:258535,v:'normalState'},{id:71568,v:'normalState'},{id:263705,v:'normalState'},{id:137307,v:'normalState'},{id:138047,v:'normalState'},{id:138569,v:'normalState'},{id:138790,v:'normalState'},{id:140090,v:'normalState'},{id:141876,v:'normalState'},{id:140990,v:'normalState'},{id:71696,v:'normalState'},{id:143474,v:'normalState'},{id:145675,v:'normalState'},{id:146224,v:'normalState'},{id:146524,v:'normalState'},{id:71828,v:'normalState'},{id:71839,v:'normalState'},{id:71871,v:'normalState'},{id:265569,v:'normalState'},{id:71886,v:'normalState'},{id:148442,v:'normalState'},{id:71901,v:'normalState'},{id:149566,v:'normalState'},{id:72343,v:'normalState'},{id:150448,v:'normalState'},{id:72366,v:'normalState'},{id:270377,v:'normalState'},{id:276519,v:'normalState'},{id:251987,v:'normalState'},{id:152981,v:'normalState'},{id:252389,v:'normalState'},{id:153456,v:'normalState'},{id:72708,v:'normalState'},{id:72717,v:'normalState'},{id:72730,v:'normalState'},{id:154714,v:'normalState'},{id:155063,v:'normalState'},{id:72778,v:'normalState'},{id:72798,v:'normalState'},{id:253008,v:'normalState'},{id:156819,v:'normalState'},{id:72876,v:'normalState'},{id:158055,v:'normalState'},{id:159399,v:'normalState'},{id:159087,v:'normalState'},{id:72918,v:'normalState'},{id:160004,v:'normalState'},{id:160595,v:'normalState'},{id:161366,v:'normalState'},{id:161978,v:'normalState'},{id:162700,v:'normalState'},{id:163714,v:'normalState'},{id:253996,v:'normalState'},{id:164692,v:'normalState'},{id:73178,v:'normalState'},{id:165771,v:'normalState'},{id:166020,v:'normalState'},{id:166434,v:'normalState'},{id:167405,v:'normalState'},{id:167561,v:'normalState'},{id:167912,v:'normalState'},{id:168190,v:'normalState'},{id:168714,v:'normalState'},{id:169359,v:'normalState'},{id:169740,v:'normalState'},{id:170995,v:'normalState'},{id:170595,v:'normalState'},{id:171443,v:'normalState'},{id:171785,v:'normalState'},{id:73490,v:'normalState'},{id:172756,v:'normalState'},{id:173430,v:'normalState'},{id:173856,v:'normalState'},{id:174179,v:'normalState'},{id:174792,v:'normalState'},{id:175196,v:'normalState'},{id:175697,v:'normalState'},{id:175935,v:'normalState'},{id:176404,v:'normalState'},{id:176766,v:'normalState'},{id:177127,v:'normalState'},{id:177365,v:'normalState'},{id:177807,v:'normalState'},{id:178012,v:'normalState'},{id:178508,v:'normalState'},{id:179036,v:'normalState'},{id:180098,v:'normalState'},{id:180109,v:'normalState'},{id:180120,v:'normalState'},{id:180131,v:'normalState'},{id:180142,v:'normalState'},{id:180153,v:'normalState'},{id:180186,v:'normalState'},{id:184123,v:'normalState'},{id:184550,v:'normalState'},{id:185360,v:'normalState'},{id:189022,v:'normalState'},{id:188399,v:'normalState'},{id:188115,v:'normalState'},{id:187477,v:'normalState'},{id:186240,v:'normalState'},{id:185519,v:'normalState'},{id:189901,v:'normalState'},{id:74031,v:'normalState'},{id:191034,v:'normalState'},{id:191342,v:'normalState'},{id:192020,v:'normalState'},{id:73912,v:'normalState'},{id:193916,v:'normalState'},{id:194301,v:'normalState'},{id:194922,v:'normalState'},{id:195786,v:'normalState'},{id:196106,v:'normalState'},{id:196798,v:'normalState'},{id:197154,v:'normalState'},{id:288274,v:'normalState'},{id:288531,v:'normalState'},{id:288699,v:'normalState'},{id:288867,v:'normalState'},{id:289035,v:'normalState'},{id:289203,v:'normalState'},{id:198076,v:'normalState'},{id:198701,v:'normalState'},{id:199374,v:'normalState'},{id:199783,v:'normalState'},{id:200245,v:'normalState'},{id:200647,v:'normalState'},{id:201058,v:'normalState'},{id:201437,v:'normalState'},{id:201938,v:'normalState'},{id:202454,v:'normalState'},{id:202702,v:'normalState'},{id:203220,v:'normalState'},{id:203751,v:'normalState'},{id:204207,v:'normalState'},{id:204586,v:'normalState'},{id:278463,v:'normalState'},{id:206148,v:'normalState'},{id:206837,v:'normalState'},{id:207144,v:'normalState'},{id:207637,v:'normalState'},{id:207993,v:'normalState'},{id:208330,v:'normalState'},{id:208553,v:'normalState'},{id:208915,v:'normalState'},{id:283775,v:'normalState'},{id:209909,v:'normalState'},{id:285451,v:'normalState'},{id:285009,v:'normalState'},{id:211370,v:'normalState'},{id:77251,v:'normalState'},{id:211924,v:'normalState'},{id:212348,v:'normalState'},{id:213905,v:'normalState'},{id:214384,v:'normalState'},{id:215243,v:'normalState'},{id:215504,v:'normalState'},{id:273787,v:'normalState'},{id:215893,v:'normalState'},{id:216319,v:'normalState'},{id:216476,v:'normalState'},{id:217030,v:'normalState'},{id:217228,v:'normalState'},{id:217831,v:'normalState'},{id:218912,v:'normalState'},{id:219560,v:'normalState'},{id:220065,v:'normalState'},{id:220543,v:'normalState'},{id:221509,v:'normalState'},{id:221985,v:'normalState'},{id:222517,v:'normalState'},{id:222945,v:'normalState'},{id:223151,v:'normalState'},{id:223471,v:'normalState'},{id:223990,v:'normalState'},{id:224318,v:'normalState'},{id:224656,v:'normalState'},{id:225082,v:'normalState'},{id:225860,v:'normalState'},{id:226247,v:'normalState'},{id:226846,v:'normalState'},{id:227459,v:'normalState'},{id:227886,v:'normalState'},{id:228051,v:'normalState'},{id:228341,v:'normalState'},{id:228816,v:'normalState'},{id:229193,v:'normalState'},{id:229954,v:'normalState'},{id:230240,v:'normalState'},{id:230733,v:'normalState'},{id:231275,v:'normalState'},{id:231481,v:'normalState'},{id:275542,v:'normalState'},{id:232509,v:'normalState'},{id:233044,v:'normalState'},{id:233416,v:'normalState'},{id:233649,v:'normalState'},{id:234908,v:'normalState'},{id:234138,v:'normalState'},{id:235861,v:'normalState'},{id:235874,v:'normalState'},{id:236337,v:'normalState'},{id:237543,v:'normalState'},{id:237427,v:'normalState'},{id:236871,v:'normalState'},{id:236609,v:'normalState'},{id:237844,v:'normalState'},{id:238143,v:'normalState'},{id:238528,v:'normalState'},{id:238723,v:'normalState'},{id:239696,v:'normalState'},{id:239999,v:'normalState'},{id:240581,v:'normalState'},{id:241192,v:'normalState'},{id:241582,v:'normalState'},{id:242128,v:'normalState'},{id:242291,v:'normalState'},{id:242800,v:'normalState'},{id:243489,v:'normalState'},{id:243640,v:'normalState'},{id:243738,v:'normalState'},{id:244006,v:'normalState'},{id:246906,v:'normalState'},{id:246560,v:'normalState'},{id:245585,v:'normalState'},{id:244205,v:'normalState'},{id:77426,v:'normalState'},{id:77424,v:'normalState'},{id:77282,v:'normalState'},{id:92610,v:'normalState'},{id:92618,v:'normalState'}]};
