function ButtonTrackingObj(exp, titleName, cm, frame){
   this.VarTrivBtnTracking = new Variable( 'VarTrivBtnTracking', null, 0, cm, frame, exp, titleName, true );
   this.title = null;
}

ButtonTrackingObj.codeToStateMap =
{
	'N' : 'normalState',
	'O' : 'overState',
	'D' : 'downState',
	'A' : 'disabledState',
	'V' : 'visitedState',
	'S' : 'selectedState'
};
ButtonTrackingObj.stateToCodeMap = {};
for (var key in ButtonTrackingObj.codeToStateMap)
	ButtonTrackingObj.stateToCodeMap[ButtonTrackingObj.codeToStateMap[key]] = key;

ButtonTrackingObj.prototype.InitPageTracking = function ( )
{
	var THIS = this;
	var pageTrackData = this.VarTrivBtnTracking.getValue();
	var bDoInit = true;
	try {
	    if (pageTrackData && pageTrackData.length > 0 && pageTrackData != '~~~null~~~')
	    {
	        var topLevelSplit = pageTrackData.split('#');
	        if (topLevelSplit && topLevelSplit.length > 1)
            {
		        var arrIds = topLevelSplit[0].split(',');
		        var arrStatus = topLevelSplit[1].split(',');
		        for( var i=0; i<arrIds.length; i++ )
		        {
			        var id = parseInt( '0x' + arrIds[i] );
			        var status = arrStatus[i];
			        var node = this.FindNode( this.title, id );
			        if( node )
						node.v = ButtonTrackingObj.codeToStateMap[status] || status;
		        }
    		}
        }
    } catch (e) { }
}

ButtonTrackingObj.prototype.FindNode = function( node, id )
{
	if( node.id == id )
		return node;
	
	var match = null;
	if( typeof( node.c ) != 'undefined' ){
		for( var i=0; i<node.c.length; i++ ){
			match = this.FindNode( node.c[i], id );
			if( match != null )
				break;
		}
	}
	
	return match;
}

ButtonTrackingObj.prototype.InternalGetRangeStatus = function( node )
{
	if( node == null )
		return -1;
		
	if( typeof(node.c) == 'undefined' )
	{
		return node.v;
	}
	else
	{
		return 'normalState';
	}
}


ButtonTrackingObj.prototype.GetRangeStatus = function( id, bInit )
{
	var status = -1;
	if ( bInit ) 
		this.InitPageTracking();
	
	status = this.InternalGetRangeStatus( this.FindNode( this.title, id ) );

	return status;
}


ButtonTrackingObj.prototype.InternalSetRangeStatus=function( node, status )
{
	if( node == null )
		return;
	node.v = status;
	if( status == 0 && typeof(node.c)!='undefined')
	{
		for( var i=0; i<node.c.length; i++ )
			this.InternalSetRangeStatus( node.c[i], status ); 
	}
}

ButtonTrackingObj.prototype.SetRangeStatus = function( id, status /*0 or 1 or 2*/)
{
	this.InternalSetRangeStatus( this.FindNode(this.title, id), status );
	
	this.SavePageTracking();
}

ButtonTrackingObj.prototype.IterateTree = function( func )
{
	var stack = [];
	stack.push( this.title );
	var i = 0;
	while( stack.length > 0 )
	{
		var node = stack.shift();
		
		if( typeof(node.c) != 'undefined' )
			stack = node.c.concat(stack);
			
		//do the thing
		func( node, i, stack );
		i++;
	}	
}

ButtonTrackingObj.prototype.SavePageTracking = function()
{
	var fnIsSaveState = window.ObjButton && ObjButton.isSaveState || function () { return false; };
	var hexString = '';
	var arrayIds = [];
	var arrayStatus= [];
	
	this.IterateTree(function(node, i, stack){
		if (fnIsSaveState(node.v))
		{
			arrayIds.push(node.id);
			arrayStatus.push(node.v);
		}
	});
	
	for( var i=0; i<arrayIds.length; i++ )
		hexString += (i > 0 ? ',' : '') + arrayIds[i].toString(16);

	hexString += (arrayIds.length > 0 ? '#' : '');
	
	for (var i = 0; i < arrayStatus.length; i++)
		hexString += (i > 0 ? ',' : '') + (ButtonTrackingObj.stateToCodeMap[arrayStatus[i]] || arrayStatus[i]);

	//LD-8267 - Added a condition to avoid tracking null/empty data unnecessarily
	if (hexString.length > 0 || (getDisplayWindow().storeSuspendData && getDisplayWindow().storeSuspendData.indexOf('VarTrivBtnTracking') >= 0) || !this.VarTrivBtnTracking.bSCORM)
		this.VarTrivBtnTracking.set(hexString);
}

var trivBtnTracking = new ButtonTrackingObj(365,'om_e_learning_module', 0, null);
trivBtnTracking.title={id:1,v:0,c:[{id:1762,v:'normalState'},{id:1758,v:'normalState'},{id:8022,v:'normalState'},{id:140875,v:'normalState'},{id:141792,v:'normalState'},{id:65893,v:'normalState'},{id:65881,v:'normalState'},{id:65871,v:'normalState'},{id:65856,v:'normalState'},{id:76668,v:'normalState'},{id:65821,v:'normalState'},{id:139208,v:'normalState'},{id:80190,v:'normalState'},{id:79847,v:'normalState'},{id:79482,v:'normalState'},{id:79301,v:'normalState'},{id:78944,v:'normalState'},{id:77701,v:'normalState'},{id:65934,v:'normalState'},{id:81806,v:'normalState'},{id:81533,v:'normalState'},{id:80740,v:'normalState'},{id:65944,v:'normalState'},{id:65964,v:'normalState'},{id:65967,v:'normalState'},{id:65970,v:'normalState'},{id:65973,v:'normalState'},{id:66015,v:'normalState'},{id:83924,v:'normalState'},{id:153480,v:'normalState'},{id:154993,v:'normalState'},{id:154399,v:'normalState'},{id:155513,v:'normalState'},{id:156152,v:'normalState'},{id:156475,v:'normalState'},{id:138841,v:'normalState'},{id:138997,v:'normalState'},{id:159970,v:'normalState'},{id:84558,v:'normalState'},{id:85213,v:'normalState'},{id:85674,v:'normalState'},{id:87308,v:'normalState'},{id:88424,v:'normalState'},{id:89237,v:'normalState'},{id:89546,v:'normalState'},{id:90074,v:'normalState'},{id:90212,v:'normalState'},{id:90580,v:'normalState'},{id:91417,v:'normalState'},{id:145236,v:'normalState'},{id:91683,v:'normalState'},{id:92072,v:'normalState'},{id:92814,v:'normalState'},{id:92959,v:'normalState'},{id:93658,v:'normalState'},{id:93922,v:'normalState'},{id:94121,v:'normalState'},{id:94585,v:'normalState'},{id:95002,v:'normalState'},{id:95342,v:'normalState'},{id:95753,v:'normalState'},{id:96115,v:'normalState'},{id:96246,v:'normalState'},{id:97169,v:'normalState'},{id:97734,v:'normalState'},{id:98307,v:'normalState'},{id:98606,v:'normalState'},{id:99175,v:'normalState'},{id:99637,v:'normalState'},{id:100076,v:'normalState'},{id:100394,v:'normalState'},{id:100821,v:'normalState'},{id:101230,v:'normalState'},{id:101694,v:'normalState'},{id:101858,v:'normalState'},{id:102489,v:'normalState'},{id:102770,v:'normalState'},{id:103099,v:'normalState'},{id:103646,v:'normalState'},{id:103967,v:'normalState'},{id:104526,v:'normalState'},{id:104969,v:'normalState'},{id:105206,v:'normalState'},{id:105410,v:'normalState'},{id:59505,v:'normalState'},{id:59257,v:'normalState'},{id:59513,v:'normalState'},{id:59337,v:'normalState'},{id:105687,v:'normalState'},{id:56517,v:'normalState'},{id:57664,v:'normalState'},{id:57671,v:'normalState'},{id:56559,v:'normalState'},{id:57684,v:'normalState'},{id:57689,v:'normalState'},{id:57696,v:'normalState'},{id:57744,v:'normalState'},{id:56886,v:'normalState'},{id:108823,v:'normalState'},{id:56970,v:'normalState'},{id:109403,v:'normalState'},{id:57845,v:'normalState'},{id:57850,v:'normalState'},{id:57858,v:'normalState'},{id:62867,v:'normalState'},{id:113340,v:'normalState'},{id:113585,v:'normalState'},{id:114379,v:'normalState'},{id:63064,v:'normalState'},{id:63123,v:'normalState'},{id:63134,v:'normalState'},{id:63139,v:'normalState'},{id:64838,v:'normalState'},{id:65073,v:'normalState'},{id:65076,v:'normalState'},{id:65084,v:'normalState'},{id:65095,v:'normalState'},{id:65103,v:'normalState'},{id:65108,v:'normalState'},{id:118731,v:'normalState'},{id:59746,v:'normalState'},{id:118926,v:'normalState'},{id:60092,v:'normalState'},{id:60118,v:'normalState'},{id:60148,v:'normalState'},{id:60160,v:'normalState'},{id:60177,v:'normalState'},{id:60469,v:'normalState'},{id:60479,v:'normalState'},{id:60293,v:'normalState'},{id:60307,v:'normalState'},{id:60888,v:'normalState'},{id:60893,v:'normalState'},{id:60896,v:'normalState'},{id:60925,v:'normalState'},{id:60931,v:'normalState'},{id:60955,v:'normalState'},{id:60958,v:'normalState'},{id:60965,v:'normalState'},{id:60978,v:'normalState'},{id:60989,v:'normalState'},{id:60802,v:'normalState'},{id:61073,v:'normalState'},{id:61312,v:'normalState'},{id:61317,v:'normalState'},{id:61330,v:'normalState'},{id:61351,v:'normalState'},{id:61368,v:'normalState'},{id:57976,v:'normalState'},{id:127805,v:'normalState'},{id:57990,v:'normalState'},{id:58004,v:'normalState'},{id:58697,v:'normalState'},{id:58060,v:'normalState'},{id:58714,v:'normalState'},{id:58770,v:'normalState'},{id:130374,v:'normalState'},{id:58775,v:'normalState'},{id:58778,v:'normalState'},{id:58785,v:'normalState'},{id:58796,v:'normalState'},{id:58807,v:'normalState'},{id:58831,v:'normalState'},{id:65145,v:'normalState'},{id:65254,v:'normalState'},{id:65159,v:'normalState'},{id:65173,v:'normalState'},{id:65187,v:'normalState'},{id:65201,v:'normalState'},{id:65215,v:'normalState'},{id:65513,v:'normalState'},{id:65528,v:'normalState'},{id:65635,v:'normalState'},{id:65636,v:'normalState'},{id:65637,v:'normalState'},{id:65638,v:'normalState'},{id:65555,v:'normalState'},{id:65350,v:'normalState'},{id:65533,v:'normalState'},{id:65540,v:'normalState'},{id:65420,v:'normalState'},{id:65615,v:'normalState'},{id:65620,v:'normalState'},{id:66171,v:'normalState'},{id:66396,v:'normalState'},{id:66409,v:'normalState'},{id:75900,v:'normalState'},{id:75908,v:'normalState'}]};
