function ButtonTrackingObj(exp, titleName, cm, frame){
   this.VarTrivBtnTracking = new Variable( 'VarTrivBtnTracking', null, 0, cm, frame, exp, titleName, true );
   this.title = null;
}

ButtonTrackingObj.codeToStateMap =
{
	'N' : 'normalState',
	'O' : 'overState',
	'D' : 'downState',
	'A' : 'disabledState',
	'V' : 'visitedState',
	'S' : 'selectedState'
};
ButtonTrackingObj.stateToCodeMap = {};
for (var key in ButtonTrackingObj.codeToStateMap)
	ButtonTrackingObj.stateToCodeMap[ButtonTrackingObj.codeToStateMap[key]] = key;

ButtonTrackingObj.prototype.InitPageTracking = function ( )
{
	var THIS = this;
	var pageTrackData = this.VarTrivBtnTracking.getValue();
	var bDoInit = true;
	try {
	    if (pageTrackData && pageTrackData.length > 0 && pageTrackData != '~~~null~~~')
	    {
	        var topLevelSplit = pageTrackData.split('#');
	        if (topLevelSplit && topLevelSplit.length > 1)
            {
		        var arrIds = topLevelSplit[0].split(',');
		        var arrStatus = topLevelSplit[1].split(',');
		        for( var i=0; i<arrIds.length; i++ )
		        {
			        var id = parseInt( '0x' + arrIds[i] );
			        var status = arrStatus[i];
			        var node = this.FindNode( this.title, id );
			        if( node )
						node.v = ButtonTrackingObj.codeToStateMap[status] || status;
		        }
    		}
        }
    } catch (e) { }
}

ButtonTrackingObj.prototype.FindNode = function( node, id )
{
	if( node.id == id )
		return node;
	
	var match = null;
	if( typeof( node.c ) != 'undefined' ){
		for( var i=0; i<node.c.length; i++ ){
			match = this.FindNode( node.c[i], id );
			if( match != null )
				break;
		}
	}
	
	return match;
}

ButtonTrackingObj.prototype.InternalGetRangeStatus = function( node )
{
	if( node == null )
		return -1;
		
	if( typeof(node.c) == 'undefined' )
	{
		return node.v;
	}
	else
	{
		return 'normalState';
	}
}


ButtonTrackingObj.prototype.GetRangeStatus = function( id, bInit )
{
	var status = -1;
	if ( bInit ) 
		this.InitPageTracking();
	
	status = this.InternalGetRangeStatus( this.FindNode( this.title, id ) );

	return status;
}


ButtonTrackingObj.prototype.InternalSetRangeStatus=function( node, status )
{
	if( node == null )
		return;
	node.v = status;
	if( status == 0 && typeof(node.c)!='undefined')
	{
		for( var i=0; i<node.c.length; i++ )
			this.InternalSetRangeStatus( node.c[i], status ); 
	}
}

ButtonTrackingObj.prototype.SetRangeStatus = function( id, status /*0 or 1 or 2*/)
{
	this.InternalSetRangeStatus( this.FindNode(this.title, id), status );
	
	this.SavePageTracking();
}

ButtonTrackingObj.prototype.IterateTree = function( func )
{
	var stack = [];
	stack.push( this.title );
	var i = 0;
	while( stack.length > 0 )
	{
		var node = stack.shift();
		
		if( typeof(node.c) != 'undefined' )
			stack = node.c.concat(stack);
			
		//do the thing
		func( node, i, stack );
		i++;
	}	
}

ButtonTrackingObj.prototype.SavePageTracking = function()
{
	var fnIsSaveState = window.ObjButton && ObjButton.isSaveState || function () { return false; };
	var hexString = '';
	var arrayIds = [];
	var arrayStatus= [];
	
	this.IterateTree(function(node, i, stack){
		if (fnIsSaveState(node.v))
		{
			arrayIds.push(node.id);
			arrayStatus.push(node.v);
		}
	});
	
	for( var i=0; i<arrayIds.length; i++ )
		hexString += (i > 0 ? ',' : '') + arrayIds[i].toString(16);

	hexString += (arrayIds.length > 0 ? '#' : '');
	
	for (var i = 0; i < arrayStatus.length; i++)
		hexString += (i > 0 ? ',' : '') + (ButtonTrackingObj.stateToCodeMap[arrayStatus[i]] || arrayStatus[i]);
	
	this.VarTrivBtnTracking.set(hexString);
}

var trivBtnTracking = new ButtonTrackingObj(365,'emar_e_learning_module', 0, null);
trivBtnTracking.title={id:1,v:0,c:[{id:1762,v:'normalState'},{id:1758,v:'normalState'},{id:8022,v:'normalState'},{id:106249,v:'normalState'},{id:106848,v:'normalState'},{id:61989,v:'normalState'},{id:61975,v:'normalState'},{id:61963,v:'normalState'},{id:61953,v:'normalState'},{id:55241,v:'normalState'},{id:55229,v:'normalState'},{id:55553,v:'normalState'},{id:55274,v:'normalState'},{id:106049,v:'normalState'},{id:106033,v:'normalState'},{id:106020,v:'normalState'},{id:106000,v:'normalState'},{id:105980,v:'normalState'},{id:105911,v:'normalState'},{id:105893,v:'normalState'},{id:107800,v:'normalState'},{id:55820,v:'normalState'},{id:55862,v:'normalState'},{id:55884,v:'normalState'},{id:55931,v:'normalState'},{id:55943,v:'normalState'},{id:55985,v:'normalState'},{id:56000,v:'normalState'},{id:56018,v:'normalState'},{id:56031,v:'normalState'},{id:112542,v:'normalState'},{id:56131,v:'normalState'},{id:56149,v:'normalState'},{id:56169,v:'normalState'},{id:56184,v:'normalState'},{id:56200,v:'normalState'},{id:56235,v:'normalState'},{id:56472,v:'normalState'},{id:56485,v:'normalState'},{id:56505,v:'normalState'},{id:56554,v:'normalState'},{id:56569,v:'normalState'},{id:56584,v:'normalState'},{id:56596,v:'normalState'},{id:56617,v:'normalState'},{id:56629,v:'normalState'},{id:56646,v:'normalState'},{id:56670,v:'normalState'},{id:56712,v:'normalState'},{id:56755,v:'normalState'},{id:56768,v:'normalState'},{id:56788,v:'normalState'},{id:56879,v:'normalState'},{id:56897,v:'normalState'},{id:56917,v:'normalState'},{id:57095,v:'normalState'},{id:57337,v:'normalState'},{id:57363,v:'normalState'},{id:57378,v:'normalState'},{id:57410,v:'normalState'},{id:57427,v:'normalState'},{id:57451,v:'normalState'},{id:57571,v:'normalState'},{id:57585,v:'normalState'},{id:57603,v:'normalState'},{id:57645,v:'normalState'},{id:60037,v:'normalState'},{id:60038,v:'normalState'},{id:57765,v:'normalState'},{id:57776,v:'normalState'},{id:57808,v:'normalState'},{id:57825,v:'normalState'},{id:58034,v:'normalState'},{id:58098,v:'normalState'},{id:58116,v:'normalState'},{id:61603,v:'normalState'},{id:58151,v:'normalState'},{id:59903,v:'normalState'},{id:59770,v:'normalState'},{id:59914,v:'normalState'},{id:59927,v:'normalState'},{id:59943,v:'normalState'},{id:59956,v:'normalState'},{id:59982,v:'normalState'},{id:59995,v:'normalState'},{id:62174,v:'normalState'},{id:62196,v:'normalState'},{id:62234,v:'normalState'},{id:62250,v:'normalState'},{id:62272,v:'normalState'},{id:58293,v:'normalState'},{id:58386,v:'normalState'},{id:58454,v:'normalState'},{id:58564,v:'normalState'},{id:59002,v:'normalState'},{id:59084,v:'normalState'},{id:59125,v:'normalState'},{id:59153,v:'normalState'},{id:59167,v:'normalState'},{id:79071,v:'normalState'},{id:80068,v:'normalState'},{id:60265,v:'normalState'},{id:60355,v:'normalState'},{id:60365,v:'normalState'},{id:114150,v:'normalState'},{id:58562,v:'normalState'},{id:58591,v:'normalState'},{id:59218,v:'normalState'},{id:59241,v:'normalState'},{id:58619,v:'normalState'},{id:58633,v:'normalState'},{id:61610,v:'normalState'},{id:58756,v:'normalState'},{id:58769,v:'normalState'},{id:61364,v:'normalState'},{id:61431,v:'normalState'},{id:61444,v:'normalState'},{id:61457,v:'normalState'},{id:61485,v:'normalState'},{id:90604,v:'normalState'},{id:61499,v:'normalState'},{id:61514,v:'normalState'},{id:61527,v:'normalState'},{id:62088,v:'normalState'},{id:62093,v:'normalState'},{id:62108,v:'normalState'},{id:59543,v:'normalState'},{id:59747,v:'normalState'},{id:59271,v:'normalState'},{id:59283,v:'normalState'},{id:59356,v:'normalState'},{id:59382,v:'normalState'},{id:59401,v:'normalState'},{id:59413,v:'normalState'},{id:59425,v:'normalState'},{id:61908,v:'normalState'},{id:59504,v:'normalState'},{id:59519,v:'normalState'},{id:60136,v:'normalState'},{id:60149,v:'normalState'},{id:60186,v:'normalState'},{id:60199,v:'normalState'},{id:115277,v:'normalState'},{id:96110,v:'normalState'},{id:96435,v:'normalState'},{id:96739,v:'normalState'},{id:115825,v:'normalState'},{id:97396,v:'normalState'},{id:60421,v:'normalState'},{id:60433,v:'normalState'},{id:60518,v:'normalState'},{id:60538,v:'normalState'},{id:60611,v:'normalState'},{id:60624,v:'normalState'},{id:60725,v:'normalState'},{id:60740,v:'normalState'},{id:60824,v:'normalState'},{id:60840,v:'normalState'},{id:62047,v:'normalState'},{id:61129,v:'normalState'},{id:61075,v:'normalState'},{id:61089,v:'normalState'},{id:61152,v:'normalState'},{id:61184,v:'normalState'},{id:61317,v:'normalState'},{id:61345,v:'normalState'},{id:61306,v:'normalState'},{id:100975,v:'normalState'},{id:62789,v:'normalState'},{id:102466,v:'normalState'},{id:61688,v:'normalState'},{id:62631,v:'normalState'},{id:62633,v:'normalState'}]};
